package game;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

import javax.swing.JOptionPane;


public class SolidBlockTemplate {
	
	private CustomImageDataII image;
	private int width;
	private int height;
	private boolean isPassThrough;
	
	public SolidBlockTemplate(String imageName, int theWidth, int theHeight, String transparentColorStr, boolean shouldBePassThrough, PonyPanel ponyPanel) {
		
//		ImageIcon ii = new ImageIcon(SolidBlockTemplate.class.getResource("images/" + imageName + ".GIF"));
		
		Color transparentColor = CustomImageData.translateFileInStringToColor(transparentColorStr);
		
//		image = new CustomImageData(ii.getImage(), theWidth, theHeight, transparentColor, ponyPanel);
		image = new CustomImageDataII("/images/" + imageName + ".GIF", transparentColor, ponyPanel);
		
		width = theWidth;
		height = theHeight;
		
		isPassThrough = shouldBePassThrough;
		
	}
	
	private SolidBlockTemplate() {
		
	}
	
	public SolidBlockSprite createSolidBlockSprite(int xPos, int yPos) {
		
		SolidBlockSprite returnValue = new SolidBlockSprite(image, width, height, xPos, yPos, isPassThrough);
		return returnValue;
	}
	
	public static SolidBlockTemplate readFromBufferedReader(BufferedReader in, int tileWidth, int tileHeight, PonyPanel ponyPanel, boolean fromFiles, String roomName) throws IOException {
		
		String inputter = null;
		
		String theImageName = null;
		String transparentColor = null;
		Boolean shouldBePassThru = null; 
		
		try {
			
			while((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/blockDef"))
					break;
				
				if(inputter.contains("graphic:")) {
					theImageName = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
					transparentColor = inputter.substring(12).trim();
				} else if(inputter.contains("passThru")) {
					shouldBePassThru = true;
				} else if(inputter.contains("solid")) {
					shouldBePassThru = false;
				}
				
			}
			
			if(shouldBePassThru == null || transparentColor == null || theImageName == null)
				return null;
			
			SolidBlockTemplate returnValue = new SolidBlockTemplate();
			
			returnValue.width = tileWidth;
			returnValue.height = tileHeight;
			returnValue.isPassThrough = shouldBePassThru;
			
//			ImageIcon ii = new ImageIcon(SolidBlockTemplate.class.getResource("images/" + theImageName + ".GIF"));
			Color transColor = CustomImageData.translateFileInStringToColor(transparentColor);
//			CustomImageData cid = new CustomImageData(ii.getImage(), tileWidth, tileHeight, transColor, ponyPanel);
			if(fromFiles) {
				returnValue.image = CustomImageDataIIRepository.loadImage(new File(theImageName), transColor, ponyPanel, roomName, theImageName);
						//new CustomImageDataII(new File(theImageName), transColor, ponyPanel);
			} else {
				CustomImageDataII cid = CustomImageDataIIRepository.loadImage("/images/" + theImageName + ".GIF", transColor, ponyPanel, roomName);
						//new CustomImageDataII("/images/" + theImageName + ".GIF", transColor, ponyPanel);
				returnValue.image = cid;
			}
			
			return returnValue;
			
			
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file, but it didn't find one.<br>This from line: "+inputter+"</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NullPointerException nurupo) {
//			nurupo.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  null pointer exception.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
	}
	
	
	

	public static void retrieveFileLengths(BufferedReader in, int tileWidth, int tileHeight, PonyPanel ponyPanel, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
		String inputter = null;
		
		String theImageName = null;
		String transparentColor = null;
		Boolean shouldBePassThru = null; 
		
		try {
			
			while((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/blockDef"))
					break;
				
				if(inputter.contains("graphic:")) {
					theImageName = inputter.substring(8).trim();
					
					
					FileInputStream fis = new FileInputStream(theImageName);
					
					long lengthOfFile = 0L;
					
					while(fis.read() != -1)
						lengthOfFile++;
					
					fis.close();
					
					fileLengths.put(theImageName, lengthOfFile);
					
				} else if(inputter.contains("transparent:")) {
//					transparentColor = inputter.substring(12).trim();
				} else if(inputter.contains("passThru")) {
//					shouldBePassThru = true;
				} else if(inputter.contains("solid")) {
//					shouldBePassThru = false;
				}
				
			}
			
//			if(shouldBePassThru == null || transparentColor == null || theImageName == null)
//				return null;
//			
//			SolidBlockTemplate returnValue = new SolidBlockTemplate();
//			
//			returnValue.width = tileWidth;
//			returnValue.height = tileHeight;
//			returnValue.isPassThrough = shouldBePassThru;
//			
////			ImageIcon ii = new ImageIcon(SolidBlockTemplate.class.getResource("images/" + theImageName + ".GIF"));
//			Color transColor = CustomImageData.translateFileInStringToColor(transparentColor);
////			CustomImageData cid = new CustomImageData(ii.getImage(), tileWidth, tileHeight, transColor, ponyPanel);
//			if(fromFiles) {
//				returnValue.image = CustomImageDataIIRepository.loadImage(new File(theImageName), transColor, ponyPanel, roomName, theImageName);
//						//new CustomImageDataII(new File(theImageName), transColor, ponyPanel);
//			} else {
//				CustomImageDataII cid = CustomImageDataIIRepository.loadImage("/images/" + theImageName + ".GIF", transColor, ponyPanel, roomName);
//						//new CustomImageDataII("/images/" + theImageName + ".GIF", transColor, ponyPanel);
//				returnValue.image = cid;
//			}
//			
//			return returnValue;
			
			
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file, but it didn't find one.<br>This from line: "+inputter+"</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch(NullPointerException nurupo) {
//			nurupo.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  null pointer exception.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
	}
	
	
}
